<?php 
include("../config.php");
include("../Datatable.php");

$obj = new Datatable($conn);

$obj->aColumns      = array('id','trip_no', 'date', 'truck_no', 'driver_id', 'start_km', 'end_km', 'created_id','cancel_flag');
$obj->eColumns      = array('id');
$obj->sIndexColumn  = "id";
$obj->sTable        = "trip";
$obj->myWhere       = " WHERE company_id = '".$_SESSION['company_id']."' AND branch_id = '".$_SESSION['branch_id']."' AND DATE(created_datetime)>='".$_SESSION['from_year']."' AND DATE(created_datetime)<='".$_SESSION['to_year']."'";

$obj->datatable_process();

$cou = 0;
if(isset($_GET['iDisplayStart'])) {
    $cou = $_GET['iDisplayStart'];
}
$master_user = combine(getAllRecords('users'), 'id', 'name');
$master_driver = combine(getAllRecords('driver_mst'), 'id', 'name');

while ($aRow = mysqli_fetch_array($obj->rResult)) {

    $temp_arr = array();
    $temp_arr[] = ++$cou;
    $temp_arr[] = $aRow['trip_no'];
    $temp_arr[] = risFormatDate($aRow['date'], 'd-m-Y');
    $temp_arr[] = $aRow['truck_no'];
    $temp_arr[] = @$master_driver[$aRow['driver_id']];
    $temp_arr[] = $aRow['start_km'];
    $temp_arr[] = $aRow['end_km'];
    $temp_arr[] = @$master_user[$aRow['created_id']];

    if ($aRow['cancel_flag'] == 'C') {
        $style = "display:none";
    } else {
        $style = "";
    }

    $str = '';
    if($aRow['cancel_flag'] != 'C'){
        if (hasPermission($_SESSION['user_detail']['role_id'], 'trip_edit')) {
            $str .= '<a href="index.php?page=trip/manage.php&p1='.$aRow['id'].'" name="edit" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="EDIT TRIP...!!"><em class="fa fa-pencil"></em></a>&nbsp;';
        }

        if (hasPermission($_SESSION['user_detail']['role_id'], 'trip_delete')) {
            $str .= '<button type="button" class="btn btn-danger delete_data" id="'.$aRow["id"].'" data-toggle="tooltip" data-placement="top" title="DELETE TRIP..!!" onclick="confirmDelete(this);"><em class="fa fa-trash"></em></button>&nbsp;';
        } 
        else {
            $str .= '<label class="cancel-flag">CANCELED</label>&nbsp;';
        }    
    }

    $str .= '<a href="trip/trip_print.php?p1='.$aRow['id'].'" name="print" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="DRIVER COPY...!!"><em class="fa fa-print"></em></a>&nbsp;';
    $str .= '<a href="trip/trip_print2.php?p1='.$aRow['id'].'" name="print" class="btn btn-danger" data-toggle="tooltip" data-placement="top" title="OFFICE COPY...!!"><em class="fa fa-print"></em></a>&nbsp;';

    // $str .= '<button type="button" class="btn btn-danger insert_data" id="'.$aRow["id"].'" data-toggle="tooltip" data-placement="top" title="CLOSED TRIP..!!" onclick="CancleFlag(this);" ><em class="fa fa-times"></em></button>';

    if( hasPermission($_SESSION['user_detail']['role_id'], 'trip_show') ) {
            $str .= '<a href="index.php?page=trip/manage_trip.php&eid='.$aRow['id'].'" name="edit" class="btn btn-danger" data-toggle="tooltip" data-placement="top"  title="TRIP CLOSING  CONFORMATION...!!"><em class="fa fa-copyright"></em></a>&nbsp;';
        }


    $temp_arr[] = $str;
    $obj->output['aaData'][] = $temp_arr;
}

// Output the result as JSON
echo json_encode($obj->output);
exit();

?>
