<?php 
$vendor = mysqli_query($conn, "SELECT DISTINCT owner_name as o_name FROM `con_lhc_grid` ORDER BY owner_name ASC");
$owner_data = array();
while ($vendor_row = mysqli_fetch_assoc($vendor)) {
  $owner_data[] = $vendor_row;
}

$lhc = mysqli_query($conn, "SELECT DISTINCT code FROM `con_lhc` ORDER BY code ASC");
$lhc_data = array();
while ($lhc_row = mysqli_fetch_assoc($lhc)) {
  $lhc_data[] = $lhc_row;
}
?>
<style type="text/css">
  .text-right{
    text-align: right !important;
  }
  .text-left{
    text-align: left !important;
  }
  .hitz-report {
    background: #fff !important;
    padding: 6px 0px 9px 0 !important;
  }
</style>
<section class="content-header">
  <div class="row">
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
        <h3 class="capital font15 padding5 bold">CONTRACT LHC REGISTER</h3>
      </div>
  </div>
</section>
<hr class="bottom35"> 
<section class="content-header bottom35-report bottom40">
    <div class="row">
    
        <div class="col-md-12 hitz-report">
            <div class="col-lg-2">
                <div class="form-group">
                    <label class="capital">START DATE</label>
                    <div class="input-group date">
                      <div class="input-group-addon">
                         <i class="fa fa-calendar"></i>
                      </div>
                      <input type="text" size="35" id="start_date" name="start_date" class="form-control date-picker start_date" placeholder="DATE" autocomplete="off" value="<?php echo risFormatDate(date('01-04-Y'))?>"/>
                    </div>
                </div>
            </div>
            <div class="col-lg-2">
                <div class="form-group">
                    <label class="capital">END DATE</label>
                    <div class="input-group date">
                      <div class="input-group-addon">
                         <i class="fa fa-calendar"></i>
                      </div>
                      <input type="text" size="35" id="end_date" name="end_date" class="form-control date-picker end_date" placeholder="DATE" autocomplete="off" value="<?php echo risFormatDate(date('d-m-Y'))?>"/>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
              <div class="form-group">
                  <label class="capital">OWNER</label>
                  <div class="form-group">
                    <select class="form-control select2" style="width: 100%;" name="owner" id="owner">
                      <option value>ALL</option>
                      <?php foreach ($owner_data as $key => $owner_datas) { ?>
                      <option value="<?php echo $owner_datas['o_name']?>"><?php echo $owner_datas['o_name']?></option>
                      <?php } ?>
                    </select>
                  </div>
              </div>
            </div>
            <div class="col-lg-2">
              <div class="form-group">
                  <label class="capital">LHC NO</label>
                  <div class="form-group">
                    <select class="form-control select2" style="width: 100%;" name="contract_code" id="contract_code">
                      <option value>ALL</option>
                      <?php foreach ($lhc_data as $key => $lhc_datas) { ?>
                      <option value="<?php echo $lhc_datas['code']?>"><?php echo $lhc_datas['code']?></option>
                      <?php  } ?>
                    </select>
                    <input type="hidden" name="module" id="module" value="CLR">
                  </div>
              </div>
            </div>
            <div class="col-md-3" style="position: relative;top: 10px;">
              <div class="form-group">
                <button type="button" class="btn btn-primary" id="btn-genrate"><i class="fa fa-refresh" aria-hidden="true"></i></button>
                <button type='submit' class="btn btn-primary" id="btnExport"><i class="fa fa-file-excel-o" aria-hidden="true"></i> EXCEL</button>
              </div>
            </div>
        </div>
    </div><br/>
    <div class="row">
      <div class="col-md-12">
          <div class="col-md-12">
              <div class="box box-info">
                  <div class="box-body table-responsive">
                      <table id="list_data" class="table table-bordered list_data">
                          <thead>
                            <tr>
                              <th class="text-center" width="50">LHC</th>
                              <th class="text-center" width="50">DATE</th>
                              <th class="text-center" width="50">TRUCK NO</th>
                              <th class="text-center" width="100">FROM - TO</th>
                              <th class="text-center" width="100">OWNER</th>
                              <th class="text-center" width="100">LORRY HIRE</th>
                              <th class="text-center" width="50">ADDITION</th>
                              <th class="text-center" width="50">TDS</th>
                              <th class="text-center" width="50">COMMISSION</th>
                              <th class="text-center" width="50">DRIVER ADV.</th>
                              <th class="text-center" width="50">DIESEL</th>
                              <th class="text-center" width="50">OTHER DEDUCTION</th>
                              <th class="text-center" width="50">ADVANCE</th>
                              <th class="text-center" width="50">PENDING</th>
                            </tr>
                          </thead>
                          <tbody>
                              <tr>
                                  <td colspan="13" class="text-center">No Data found to show !!</td>
                              </tr>
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>
      </div>
    </div>
</section>

<script type="text/javascript">
  jQuery(document).ready(function() {
    $('#owner').select2();
    $('#contract_code').select2();
    jQuery(document).on('click', '#btn-genrate', function(e){
      getData();
    });

    jQuery(document).on('click', '#btnExport', function(e){
      ExportExcel();
    });
  });
  
  function ExportExcel(){
    $("#list_data").table2excel({
      filename: "CONTRACT_LHC_REGISTER.xls"
    });
  }

  function getData() {
    var url = "report/contract_lhc_register_data.php?>" + '&start_date=' + jQuery('#start_date').val() + '&end_date=' + jQuery('#end_date').val() + '&owner=' + jQuery('#owner').val() + '&contract_code=' + jQuery('#contract_code').val();
    //jQuery('#list_data .start_date').html(jQuery('#start_date').text());
    //jQuery('#list_data .end_date').html(jQuery('#end_date').text());
    jQuery.ajax({
      type        : 'GET',
      url         :  url,
      dataType    : 'JSON',
      beforeSend:function(){
        jQuery('#list_data tbody').html('<tr><td colspan="13" class="text-center"><i class="fa fa-2x fa-spin fa-spinner"></i> Loading Data....</td></tr>');
      },
      success: function(data) {
        if(data.status == 'success') {
          if(data.tbody != '') {
            jQuery('#list_data tbody').html(data.tbody);
            jQuery('.total-records').html(data.total_count);  
            jQuery('.min_data').html(data.min_data);  
            jQuery('.max_data').html(data.max_data);
            jQuery('.average').html(data.average);
          } else {
            jQuery('#list_data tbody').html('<tr><td colspan="12" class="text-center">No Data found to show !!</td></tr>');
            jQuery('.total-records').html(0);
          }
        }
      }
    });
  }
</script>