<?php 
    include("../config.php");
    include("../Datatable.php");


    $obj = new Datatable($conn);

    $obj->aColumns      = array('code', 'date', 'truck_no', 'payment_type', 'lhc_no', 'adjust_amount', 'created_id');
    $obj->eColumns      = array('id');
    $obj->sIndexColumn  = "id";
    $obj->sTable        = "lhc_balance_payment";
    $obj->datatable_process();
    
    $cou = 0;
    if(isset($_GET['iDisplayStart'])) {
        $cou = $_GET['iDisplayStart'];
    }
    $master_user = combine(getAllRecords('users'), 'id', 'name');
    $master_act = combine(getAllRecords('act_master'), 'act_code', 'ac_name');
    while ($aRow = mysqli_fetch_array($obj->rResult)) {
        $temp_arr = array();

        $temp_arr[] = ++$cou;
        $temp_arr[] = $aRow['code'];
        $temp_arr[] = risFormatDate($aRow['date'],'d-m-Y');
        $temp_arr[] = $aRow['lhc_no'];
        $temp_arr[] = $aRow['truck_no'];
        $temp_arr[] = $aRow['adjust_amount'];
        $temp_arr[] = $aRow['payment_type'];
        $temp_arr[] = @$master_user[$aRow['created_id']];
        $str = '';
        
        if( hasPermission($_SESSION['user_detail']['role_id'], 'lhc_balance_payment_delete') ) {
        	$str .= '<button type="button" class="btn btn-danger delete_data" id="'.$aRow["id"].'" data-toggle="tooltip" data-placement="top" title="DELETE LHC PAYMENT..!!" onclick="confirmDelete(this);"><em class="fa fa-trash"></em></button>';
        }
        $temp_arr[] = $str;

        $obj->output['aaData'][] = $temp_arr;
    }

    echo json_encode($obj->output);
    exit();
?>