<?php 
	include("../config.php");
	include("../Datatable.php");


	$obj = new Datatable($conn);

	$obj->aColumns 		= array('journal_voucher.jv_no', 'journal_voucher.jv_date', 'journal_voucher.main_acc', 'journal_voucher.t_mode', 'journal_voucher.total_amount', 'act_master.ac_name AS aname', 'journal_voucher.created_id');
    $obj->eColumns 		= array('journal_voucher.id');
    $obj->sIndexColumn 	= "journal_voucher.id";
    $obj->sTable 		= "journal_voucher";
    $obj->myWhere 		= "JOIN act_master ON journal_voucher.main_acc=act_master.act_code WHERE 1=1 AND journal_voucher.company_id = '".$_SESSION['company_id']."' AND journal_voucher.branch_id = '".$_SESSION['branch_id']."' AND DATE(journal_voucher.jv_date)>='".$_SESSION['from_year']."' AND DATE(journal_voucher.jv_date)<='".$_SESSION['to_year']."'";
    $obj->groupBy       = 'GROUP BY journal_voucher.jv_no';
    $obj->datatable_process();

    $cou = 0;
    if(isset($_GET['iDisplayStart'])) {
    	$cou = $_GET['iDisplayStart'];
    }
    $master_user = combine(getAllRecords('users'), 'id', 'name');
    while ($aRow = mysqli_fetch_array($obj->rResult)) {
        $temp_arr = array();
        
        $temp_arr[] = ++$cou;
		$temp_arr[] = $aRow['jv_no'];
		$temp_arr[] = date("d-m-Y", strtotime($aRow['jv_date']));
		$temp_arr[] = $aRow['aname'];
		$temp_arr[] = $aRow['t_mode'];
		$temp_arr[] = customFormatMoney($aRow['total_amount']);
		$temp_arr[] = @$master_user[$aRow['created_id']];
		
		$str = '';
		if( hasPermission($_SESSION['user_detail']['role_id'], 'jv_edit') ) {
		$str .= '<a href="index.php?page=journal_voucher/edit.php&eid='.$aRow['jv_no'].'" name="edit" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="EDIT JV...!!"><em class="fa fa-pencil"></em></a>&nbsp;';
		}

		if( hasPermission($_SESSION['user_detail']['role_id'], 'jv_delete') ) {
		$str .= '<button type="button" class="btn btn-danger delete_data" id="'.$aRow["jv_no"].'" data-toggle="tooltip" data-placement="top" title="DELETE JV..!!" onclick="confirmDelete(this);"><em class="fa fa-trash"></em></button>';
		}
		$temp_arr[] = $str;

        $obj->output['aaData'][] = $temp_arr;
    }

    echo json_encode($obj->output);
    exit();
?>