<?php
  if( !hasPermission($_SESSION['user_detail']['role_id'], 'ba_add') ) {
    echo '<script>window.location.href="index.php?page=no_permission.php"</script>';die();
  }

  $vendor = mysqli_query($conn, "SELECT DISTINCT vendor_id AS vendor_id FROM `contract` WHERE `billing_status` != 'Y' ORDER BY vendor_id");
  $vendor_data = array();
  while ($vendor_row = mysqli_fetch_assoc($vendor)) {
    $vendor_data[] = $vendor_row;
  }

  $master_vendor = combine(getAllRecords('vendor_master'), 'id', 'name');
?>
<link rel="stylesheet" href="assets/plugins/toaster/jquery.toast.css">
<link rel="stylesheet" href="assets/plugins/toaster/jquery.toast.min.css">
<script src="assets/plugins/toaster/jquery.toast.js"></script>
<section class="content-header">
  <div class="row">
    <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
      <h3 class="capital font15 padding5 bold">ADD NEW BALANCE ADVIVCE</h3>
    </div>
    <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 text-right bottom20">
      <h3> <?php if( hasPermission($_SESSION['user_detail']['role_id'], 'ba_list') ) { ?>
        <a href="index.php?page=balance_advice/list.php" class="btn btn-danger capital bottom10 custome-btn">VIEW BALANCE ADVIVCE DETAILS</a>
        <?php } ?>
      </h3>
    </div>
  </div>
</section>
<hr class="bottom35"> 
<section class="hitz-top-header">
   <div class="row bottom40">
      <div class="col-xs-12">
         <div class="box box-success">
            <div class="box-body">
              <form action="balance_advice/insert.php" method="post" enctype="multipart/form-data" class="common-frm-validation" id="signupForm">
                <div class="row">
                  <div class="col-md-2">
                    <div class="form-group">
                      <label class="capital">INVOICE NO</label><span class="error">*</span>
                      <input type="text" size="35" id="con_bill" name="con_bill" class="form-control lr_number" autocomplete="off" placeholder="INVOICE NO" onChange="CheckCode(this.value);"value="<?php echo CBillCode($conn);?>"  autofocus=""
                      />
                    </div>
                  </div>

                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="capital">vendor</label><span class="error">*</span>
                      <select class="form-control select2 required product-name" name="vendor_id" id="vendor_id">
                        <option></option>
                        <?php foreach ($vendor_data as $key => $vendor_datas) { ?>
                        <option value="<?php echo $vendor_datas['vendor_id']?>"><?php echo @$master_vendor[$vendor_datas['vendor_id']]?></option>
                        <?php } ?>
                      </select>
                    </div>
                  </div>

                  <div class="col-sm-2">
                    <div class="form-group">
                        <label class="capital">DATE</label><span class="error">*</span>
                        <div class="input-group date date-picker" data-date-format="dd-mm-yyyy">
                          <div class="input-group-addon">
                             <i class="fa fa-calendar"></i>
                          </div>
                          <input type="text" size="35" id="con_bill_date" name="con_bill_date" class="form-control date-picker required" placeholder="DATE" autocomplete="off" value="<?php echo date('d-m-Y')?>" />
                       </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-xs-12 col-sm-12">
                    <div id="product-wapper">
                      <table class="table table-bordered table-responsive">
                        <thead>
                          <tr>
                            <th class="text-center" width="3%">#</th>
                            <th class="text-center" width="8%">CONTRACT NO</th>
                            <th class="text-center" width="9%">DATE</th>
                            <th class="text-center" width="10%">TRUCK</th>
                            <th class="text-center" width="8%">FROM</th>
                            <th class="text-center" width="8%">TO</th>
                            <th class="text-center" width="5%">WEIGHT</th>
                            <th class="text-center" width="7%">AMOUNT</th>
                            <th class="text-center" width="7%">ADVANCE</th>
                            <th class="text-center" width="7%">BALANCE</th>
                            <th class="text-center" width="7%">L.R.No</th>
                            <th class="text-center" width="9%">Date</th>
                            <th class="text-center" width="6%">Detention</th>
                            <th class="text-center" width="6%">Hamali</th>
                            <th class="text-center" width="6%">Other</th>
                            <th class="text-center" width="6%">Remarks</th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <th colspan="12" class="text-center">NO DATA FOUND...!!!</th>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-sm-12">
                    <div class="form-group">
                      <label class="capital">remark</label>
                      <textarea class="form-control" autocomplete="off" name="remark" id="remark" style="height: 50px !important;"></textarea>
                    </div>
                  </div>
                </div>
                <input type="hidden" value="" name="id" id="id">
                <hr>
                <div class="row" align="center">
                  <button id="btn" class="btn btn-primary ajax-submit capital" type="submit"> Save & List</button>
                  <a href="index.php?page=balance_advice/list.php" class="btn btn-danger capital"> Cancel</a>
                </div>
              </form>
            </div>
         </div>
      </div>
   </div>
</section>
<script type="text/javascript">
jQuery(document).ready(function() {
  jQuery('#vendor_id').select2();

  jQuery(document).on('change', "#vendor_id", function() {
    GetContactData();
  });
});

function GetContactData(ele){
  $vendor_id  = jQuery('#vendor_id').val();
  $.ajax({
    type: "POST",
    url: 'balance_advice/get_contract_data.php',
    data: {
    'vendor_id' : $vendor_id
    },
    dataType : 'JSON',
    beforeSend: function() {
      jQuery('#product-wapper tbody').html('<tr><td colspan="10" class="text-center"><i class="fa fa-2x fa-spin fa-spinner"></i> Loading Data....</td></tr>');
    },
    success: function(data){
      if(data.tbody != '') {
        jQuery('#product-wapper tbody').html(data.tbody);
      }
    }
  });
}

  function CheckCode() {
    var lr_no      = $("#con_bill").val();
    $.ajax({
      'type': 'POST',
      'url': 'balance_advice/check-code.php',
      'data': {
        'lr_no': lr_no
      },
      dataType: 'JSON',
      success: function (result) {
        if(result.status == 1) {
          swal("Opps !!", "ALREADY CODE EXIST...!!!", "info");
          setTimeout("location.reload(true);",200);
          $('#lr_no').val('').trigger('focus');   
        }else{
          jQuery('.ajax-submit').attr('enable', true);
        }
      }
    });
  }

</script>